// Datasheet:https://www.analog.com/media/en/technical-documentation/data-sheets/ds1307.pdf

// Constant Values
const unsigned short DS1307_SUN = 0x01;
const unsigned short DS1307_MON = 0x02;
const unsigned short DS1307_TUE = 0x03;
const unsigned short DS1307_WED = 0x04;
const unsigned short DS1307_THU = 0x05;
const unsigned short DS1307_FRI = 0x06;
const unsigned short DS1307_SAT = 0x07;

// Global Variables
char DS1307_Date_String[]         = "DD/MM/20YY";
char DS1307_Time_String[]         = "HH:MM:SS";
char DS1307_DAY_String[2];
char DS1307_MONTH_String[2];
char DS1307_YEAR_String[2];
char DS1307_HOUR_String[2];
char DS1307_MINUTE_String[2];
char DS1307_SECOND_String[2];
unsigned short DS1307_Second;
unsigned short DS1307_Minute;
unsigned short DS1307_Hour;
unsigned short DS1307_DayOfWeek;
unsigned short DS1307_Day;
unsigned short DS1307_Month;
unsigned short DS1307_Year;

unsigned short ConvertToHex(unsigned short value){
  return (value/10)*16 + value%10;
}


unsigned short ConvertDS1307Data(unsigned short value){
  return ((value & 0xF0)>>4)*10 + (value & 0x0F);
}

void ConvertToStr(unsigned short value, unsigned short *dest){
  dest[0]=value/10+48;
  dest[1]=value%10+48;
}

void UpdateDayOfWeek(unsigned short src[], unsigned short dest[]){
  src[0]=dest[0];
  src[1]=dest[1];
  src[2]=dest[2];
}

void SetDateTime(unsigned short day, unsigned short month, unsigned short year, unsigned short dayOfWeek, unsigned short hour, unsigned short minute, unsigned short second){
  I2C_Start();
  I2C_Write(0xD0);
  I2C_Write(0x00);
  I2C_Write(ConvertToHex(second));
  I2C_Write(ConvertToHex(minute));
  I2C_Write(ConvertToHex(hour));
  I2C_Write(ConvertToHex(dayOfWeek));
  I2C_Write(ConvertToHex(day));
  I2C_Write(ConvertToHex(month));
  I2C_Write(ConvertToHex(year));
  I2C_Stop();
}

void ReadDS1307(){
  // Get All Data
  I2C_Start();
  I2C_Write(0xD0);
  I2C_Write(0);
  I2C_Start();
  I2C_Write(0xD1);

  DS1307_Second    = ConvertDS1307Data(I2C_Read(1));
  DS1307_Minute    = ConvertDS1307Data(I2C_Read(1));
  DS1307_Hour      = ConvertDS1307Data(I2C_Read(1));
  DS1307_DayOfWeek = ConvertDS1307Data(I2C_Read(1));
  DS1307_Day       = ConvertDS1307Data(I2C_Read(1));
  DS1307_Month     = ConvertDS1307Data(I2C_Read(1));
  DS1307_Year      = ConvertDS1307Data(I2C_Read(0));
  I2C_Stop();

  // Day
  ConvertToStr(DS1307_Day,&DS1307_DAY_String);
  DS1307_Date_String[0]  = DS1307_DAY_String[0];
  DS1307_Date_String[1]  = DS1307_DAY_String[1];
  // Month
  ConvertToStr(DS1307_Month,&DS1307_MONTH_String);
  DS1307_Date_String[3]  = DS1307_MONTH_String[0];
  DS1307_Date_String[4]  = DS1307_MONTH_String[1];
  // Year
  ConvertToStr(DS1307_Year,&DS1307_YEAR_String);
  DS1307_Date_String[8]  = DS1307_YEAR_String[0];
  DS1307_Date_String[9]  = DS1307_YEAR_String[1];
  // Hour
  ConvertToStr(DS1307_Hour,&DS1307_HOUR_String);
  DS1307_Time_String[0]  = DS1307_HOUR_String[0];
  DS1307_Time_String[1]  = DS1307_HOUR_String[1];
  // Minute
  ConvertToStr(DS1307_Minute,&DS1307_MINUTE_String);
  DS1307_Time_String[3]  = DS1307_MINUTE_String[0];
  DS1307_Time_String[4]  = DS1307_MINUTE_String[1];
  // Second
  ConvertToStr(DS1307_Second,&DS1307_SECOND_String);
  DS1307_Time_String[6]  = DS1307_SECOND_String[0];
  DS1307_Time_String[7]  = DS1307_SECOND_String[1];
}